#include <Arduino_BMI270_BMM150.h>

static const int SAMPLE_RATE_HZ = 100;
static const int SAMPLE_PERIOD_MS = 10 / SAMPLE_RATE_HZ;

volatile int currentLabel = 0;

void setup() {
  Serial.begin(115200);
  while (!Serial) {}

  if (!IMU.begin()) {
    Serial.println("ERROR: IMU init failed (BMI270).");
    while (1) {}
  }

  //Serial.println("t_ms,ax,ay,az,gx,gy,gz,label");
  Serial.println("ax,ay,az,gx,gy,gz");
}

void loop() {
  if (Serial.available()) {
    int v = Serial.parseInt();
    if (v >= 0) currentLabel = v;
    while (Serial.available()) Serial.read();
  }

  float ax, ay, az, gx, gy, gz;

  if (IMU.accelerationAvailable() && IMU.gyroscopeAvailable()) {
    IMU.readAcceleration(ax, ay, az);
    IMU.readGyroscope(gx, gy, gz);

    unsigned long t = millis();
    //Serial.print(t);
    //Serial.print(",");
    Serial.print(ax, 6);
    Serial.print(",");
    Serial.print(ay, 6);
    Serial.print(",");
    Serial.print(az, 6);
    Serial.print(",");
    Serial.print(gx, 6);
    Serial.print(",");
    Serial.print(gy, 6);
    Serial.print(",");
    Serial.println(gz, 6);
    //Serial.print(",");
    //Serial.println(currentLabel);
  }

  delay(SAMPLE_PERIOD_MS);
}
